<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <!--Turnout Report-->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!--Title displayed in browser Title Bar-->
                <title lang="en">Výpis výhybek</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!--Report Title-->
                                <h2 lang="en">Výpis výhybek</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            
                            <!--Project Data-->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%"><xsl:value-of select="../@inputGridScaleFactor" /></td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr />
                                <xsl:for-each select="Turnout">
                                    <table class="margin" cellpadding="2" cellspacing="1" width="90%">
                                        <thead>
                                            <colgroup span="6">
                                                <col width="20%"/>
                                                <col width="16%"/>
                                                <col width="16%"/>
                                                <col width="16%"/>
                                                <col width="16%"/>
                                                <col width="16%"/>
                                            </colgroup>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td align="left" colspan="6" lang="en"><strong>Výhybka:&#xa0; </strong>
                                                    <xsl:value-of select="@name"/>
                                                    <xsl:text>&#xa0;</xsl:text>
                                                    <xsl:value-of select="@description"/>
                                                    (<xsl:value-of select="@style"/>)
                                                </td>
                                            </tr>
                                            <tr>
                                              <td align="left" colspan="6" lang="en">
                                                  <i>Vložení</i>:&#xa0;<xsl:value-of select="@placement"/>,&#xa0;
                                                  <i>Strana</i>:&#xa0;<xsl:value-of select="@hand"/>,&#xa0;
                                                  <i>Orientace</i>:&#xa0;<xsl:value-of select="@orientation"/>
                                              </td>
                                            </tr>
                                          <xsl:apply-templates />
                                        </tbody>
                                    </table>
                                    <hr />
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    
    <!-- Turnout Horizontal Line Data -->
    <xsl:template match="HorizontalLine">
        <xsl:if test="position() = 10 or position() = 20 or preceding-sibling::*[1][name() = 'TurnoutPoint']">
            <tr>
                <th align="left"  lang="en">Typ prvku</th>
                <th align="right" lang="en">Začátek Y<sub>s-jtsk</sub></th>
                <th align="right" lang="en">Začátek X<sub>s-jtsk</sub></th>
                <th align="right" lang="en">Délka</th>
                <th align="right" lang="en">Počáteční poloměr</th>
                <th align="right" lang="en">Koncový poloměr</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left" lang="en">Přímá</td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting)*(-1))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing)*(-1))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>   
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(0.))"/>
            </td>   
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(0.))"/>
            </td>
        </tr>
    </xsl:template>
    
    <!-- Turnout Horizontal Circle Data -->
    <xsl:template match="HorizontalCircle">
        <xsl:if test="position() = 10 or position() = 20 or preceding-sibling::*[1][name() = 'TurnoutPoint']">
            <tr>
                <th align="left"  lang="en">Typ prvku</th>
                <th align="right" lang="en">Začátek Y<sub>s-jtsk</sub></th>
                <th align="right" lang="en">Začátek X<sub>s-jtsk</sub></th>
                <th align="right" lang="en">Délka</th>
                <th align="right" lang="en">Počáteční poloměr</th>
                <th align="right" lang="en">Koncový poloměr</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left" lang="en">Circular</td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting)*(-1))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing)*(-1))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>  
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>  
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>
        </tr>
    </xsl:template>
    
    <!-- Turnout Horizontal Spiral Data -->
    <xsl:template match="HorizontalSpiral">
        <xsl:if test="position() = 10 or position() = 20 or preceding-sibling::*[1][name() = 'TurnoutPoint']">
            <tr>
                <th align="left"  lang="en">Typ prvku</th>
                <th align="right" lang="en">Začátek Y<sub>s-jtsk</sub></th>
                <th align="right" lang="en">Začátek X<sub>s-jtsk</sub></th>
                <th align="right" lang="en">Délka</th>
                <th align="right" lang="en">Počáteční poloměr</th>
                <th align="right" lang="en">Koncový poloměr</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left" lang="en">Klotoida</td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting)*(-1))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing)*(-1))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td> 
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@startRadius))"/>
            </td> 
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@endRadius))"/>
            </td>
        </tr>
    </xsl:template>
    
    <!-- Turnout Points -->
    <xsl:template match="TurnoutPoint">
        <xsl:if test="preceding-sibling::*[1][name() != 'TurnoutPoint']">
            <tr>
                <td></td>
            </tr>
            <tr>
                <th align="left"  lang="en">Název bodu</th>
                <th align="right" lang="en">Y<sub>s-jtsk</sub></th>
                <th align="right" lang="en">X<sub>s-jtsk</sub></th>
                <th align="right" lang="en">Z</th>
                <th align="right" lang="en">Poloměr</th>
                <th align="right" lang="en">Odstup</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left"><xsl:value-of select="GeometryPoint/@name"/></td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting)*(-1))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing)*(-1))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@elevation))"/>
            </td>  
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(GeometryPoint/@radius))"/>
            </td>  
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(GeometryPoint/@offset))"/>
            </td>
            <td />
        </tr>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <xsl:text>Copyright 2018 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
